unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls,
  Clipbrd;

type
  TfMain = class(TForm)
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Edit1: TEdit;
    btnSetText: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    Image1: TImage;
    BitBtn5: TBitBtn;
    Image2: TImage;
    BitBtn6: TBitBtn;
    procedure BitBtn6Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure btnSetTextClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fMain: TfMain;

implementation

{$R *.dfm}

procedure TfMain.BitBtn1Click(Sender: TObject);
begin
	Close();
end;

procedure TfMain.BitBtn2Click(Sender: TObject);
var
	txt : String;

begin
   txt := Edit1.Text;
   if Trim(txt) <> '' then
   begin
      Clipboard.SetTextBuf(PAnsiChar(txt));
   end;
end;

procedure TfMain.btnSetTextClick(Sender: TObject);
begin
	if Clipboard.HasFormat(CF_TEXT) then
   begin
   	Edit1.Text := Clipboard.AsText;
   end;
end;

procedure TfMain.BitBtn3Click(Sender: TObject);
begin
	Clipboard.Assign(btnSetText.Glyph);
   // po uteraz przycisk ju nie posiada elementu graficznego
   btnSetText.Glyph := Nil;
end;

procedure TfMain.BitBtn4Click(Sender: TObject);
begin
	if Clipboard.HasFormat(CF_BITMAP) then
   begin
      btnSetText.Glyph.Assign(Clipboard());
   end;
end;

procedure TfMain.BitBtn5Click(Sender: TObject);
begin
	Clipboard.Assign(Image1.Picture.Bitmap);
	Image1.Picture := Nil;
end;

procedure TfMain.BitBtn6Click(Sender: TObject);
begin
	if Clipboard.HasFormat(CF_BITMAP) then
   begin
		Image2.Picture.Bitmap.Assign(Clipboard());
   end;
end;

end.
